package control;

import java.awt.Color;
import java.awt.Dimension;
import java.lang.reflect.*;

import javax.swing.*;

import container.GeomContainer;

/**
 * \ingroup Container
 * \brief Панель управляющих виджетов (кнопок вызавающих \ref control.Commands "команды" и \ref control.Indicators "индикаторов"). 
 * Виждеты добавляются в \ref control.CommandBox#CommandBox() "конструкторе" и при помощи функции 
 * \ref control.CommandBox#add() "add"
 */
public class CommandBox extends JPanel
{

	private int width = 140;
	private int heightComponent = 30;
	private GeomContainer gAllObjects;
	private boolean autoBuild;

	public CommandBox(GeomContainer gAllObjects, boolean autoBuild) {
		this.gAllObjects = gAllObjects;
		this.autoBuild = autoBuild;
	
		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
		Box.createHorizontalStrut(width);

		if (this.autoBuild)
		{
			Method methods[] = Indicators.class.getMethods();
			
			
			for (Method method : methods)
			{
				if (Modifier.isStatic (method.getModifiers()))
				{
				    this.add(new IndicatorLabel(addSpaces(method.getName()), method.getName(), gAllObjects));
				}    
			}
			
			methods = Commands.class.getMethods();
			
			for (Method method : methods)
			{
				if (Modifier.isStatic (method.getModifiers()))
				{
					this.add(new CommandButton(addSpaces(method.getName()), method.getName(), gAllObjects));
				}	
			}
			return; 
		}
		
		// ///////////////////////////////////////
		// ADD INDICATOR LABELS HERE
		// for static methods from Indicators class
		// prototype mast be: static String methodName(GeomContainer gObjects)
		// from Indicator class
		// //////////////////////////////////////

		add(new IndicatorLabel("Objects", "size", gAllObjects));
		add(new IndicatorLabel("Selected", "selectedSize", gAllObjects));

		// ///////////////////////////////////////
		// ADD COMMAND BUTTONS HERE
		// for static methods from Commands class
		// prototype must be: static void methodName(GeomContainer gObjects)
		// from Commands class
		// //////////////////////////////////////
		this.add(new CommandButton("Clear", "clear", gAllObjects));
		this.add(new CommandButton("Select All", "selectAll", gAllObjects));
		this.add(new CommandButton("Deselect All", "deselectAll", gAllObjects));
		this.add(new CommandButton("Del Last selected", "delLastSelected",
				gAllObjects));
		this.add(Box.createVerticalStrut(10));
		this.add(new CommandButton("Make Line", "makeLine", gAllObjects));
		this.add(new CommandButton("Cross Lines", "crossLines", gAllObjects));
	}

	/**
	 * \brief добавляет на панель управляющий виджет
	 */
	public void add(JComponent comp)
	{
		comp.setPreferredSize(new Dimension(width, heightComponent));
		comp.setMaximumSize(new Dimension(Short.MAX_VALUE, heightComponent));
		comp.setMinimumSize(new Dimension(width, heightComponent));
		super.add(comp);
	}
	
	private String addSpaces(String text)
	{
		StringBuffer res = new StringBuffer("");
		res.append(Character.toUpperCase(text.charAt(0)));
		for (int i = 1; i < text.length(); i++)
		{
			char c = text.charAt(i);
			if (Character.isUpperCase(c))
			{
				res.append(" ");
			}	
			res.append(c);
		}	
		return new String(res);
	}

}
