package control;

import javax.swing.JOptionPane;

/**
 * \brief Система вывода сообщений
 */
public class Message
{
	public enum Type
	{
		CONSOLE, WINDOW
	}

	private static Type type;

	/**
	 * \brief Функция вывода сообщения
	 */
	public static void out(String messageText)
	{
		switch (type)
			{
			case CONSOLE:
				System.out.println(messageText);
				break;
			case WINDOW:
				JOptionPane.showMessageDialog(null, messageText);
				break;
			}

	}

	/**
	 * \brief Настройка отображения (диалоговые окна или консоль)
	 */

	public static void setup(Type mtype)
	{
		type = mtype;
	}
}
