package control;

import geom.GCoordSystem;
/** 
\brief Класс главного окна
*/

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import container.GeomContainer;

public class GeomFrame extends JFrame
{
	GCoordSystem gcs;
	CommandBox cmdBox;
	GeomContainer gObjects;

	public GeomFrame() {
		Message.setup(Message.Type.WINDOW);
		gObjects = new GeomContainer(gcs);
		cmdBox = new CommandBox(gObjects, false);
		gcs = new GCoordSystem(gObjects, true);
		setSize(600, 550);
		Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((sSize.width - this.getWidth()) / 2,
				(sSize.height - this.getHeight()) / 2);
		setTitle("Geometry Algorithms");
		Container cont = getContentPane();
		cont.add(cmdBox, BorderLayout.EAST);
		cont.add(gcs.getControl(), BorderLayout.NORTH);
		cont.add(gcs);

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);
	}
}
