package control;

import container.GeomContainer;

/**
 * \brief Индикаторы - статические функции с прототипом public String void
 * methodName(GeomContainer gObjects)
 * 
 * Добавляются на объект control.CommandBox в его конструкторе или
 * непосредственным вызовом функции control.CommandBox#add(java.awt.Component)
 * 
 * Пример для функции \ref control.Indicators#size() "size()" \code this.add(new
 * Indicators("size", "size", gAllObjects)); \endcode
 * 
 * Работают c контейнером (объектом сontainer.GeomContainer)
 */
public class Indicators
{
	/**
	 * \brief Индикатор количества объектов в конейнере
	 */
	public static String size(GeomContainer gObjects)
	{
		return "" + gObjects.size();
	}

	/**
	 * \brief Индикатор количества выделеных объектов в контейнере
	 */
	public static String selectedSize(GeomContainer gObjects)
	{
		return "" + gObjects.getSelectedObjects().size();
	}
}
