package geom;

import java.awt.Color;
import java.awt.Graphics;

public class GView
{

	public static int maxSelId = 0;

	public int selId = 0;

	public void select()
	{
		this.selId = maxSelId++;
		this.setState(EGState.SELECTED);

	}

	public void deselect()
	{
		this.selId = 0;
		this.setState(EGState.NORMAL);
	}

	public boolean isSelected()
	{
		if (state == EGState.SELECTED)
			return true;
		return false;
	}

	public void highLight()
	{
		this.selId = 0;
		this.setState(EGState.HIGHLIGHTED);

	}

	public void chooseColor(Color normalColor, Color highLightedColor,
			Color selectedColor, GCoordSystem gcs)
	{
		Color drawColor;
		switch (getState())
			{
			case HIGHLIGHTED:
				drawColor = highLightedColor;
				break;
			case SELECTED:
				drawColor = selectedColor;
				break;
			default:
				drawColor = normalColor;
			}
		gcs.getCanvas().setPaint(drawColor);
	}

	EGState state = EGState.NORMAL;

	public void draw(GCoordSystem gcs)
	{

	}

	public EGState getState(EGState state)
	{
		return this.state;
	}

	public void setState(EGState state)
	{
		this.state = state;
	}

	public EGState getState()
	{
		return state;
	}

	public int getSelId()
	{
		return this.selId;
	}

	enum EGState
	{
		NORMAL, HIGHLIGHTED, SELECTED
	}

}
