package geom;

import geom.GView.EGState;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

import container.GeomContainer;

/**
 * \brief Главный класс отображения. У пользователя нет необходимости его
 * использовать напрямую.
 */
public class GCoordSystem extends JPanel implements MouseListener,
		MouseMotionListener, MouseWheelListener,
		container.IGeomContainerListener
{
	private int x0, y0;
	private double scale = 0.1;

	public int gEps = 5;

	private Graphics2D graphics = null;
	private GeomContainer gObjects = null;

	private boolean axes = true;
	private boolean createSel = true;

	private GCSControl control;

	public GCSControl getControl()
	{
		return control;
	}

	public void setAxes(boolean axes)
	{
		this.axes = axes;
		repaint();
	}

	public void setCreateSel(boolean createSel)
	{
		this.createSel = createSel;
	}

	public GCoordSystem(GeomContainer gObjects, boolean axes) {
		control = new GCSControl(this);
		this.gObjects = gObjects;
		setBackground(Color.WHITE);
		this.axes = axes;
		x0 = 100;
		y0 = 100;
		this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 5));
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.addMouseWheelListener(this);
		this.gObjects.addListener(this);
	}

	public Graphics2D getCanvas()
	{
		return graphics;
	}

	public void paintComponent(Graphics g)
	{
		Graphics2D g2d = (Graphics2D) g;
		if (graphics == null)
		{
			x0 = this.getWidth() / 2;
			y0 = this.getHeight() / 2;
		}
		graphics = g2d;
		super.paintComponent(g2d);

		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);

		if (axes)
		{

			g.setColor(Color.LIGHT_GRAY);
			int step = (int) (2 / getScale());
			for (int i = x0; i < getWidth(); i += step)
			{
				g.drawLine(i, 0, i, getHeight());
			}
			for (int i = y0; i < getHeight(); i += step)
			{
				g.drawLine(0, i, getWidth(), i);
			}
			for (int i = x0; i >= 0; i -= step)
			{
				g.drawLine(i, 0, i, getHeight());
			}
			for (int i = y0; i >= 0; i -= step)
			{
				g.drawLine(0, i, getWidth(), i);
			}

			g.setColor(Color.BLACK);
			g.drawLine(0, y0, getWidth(), y0);
			g.drawLine(x0, 0, x0, getHeight());

		}

		gObjects.draw(this);
	}

	public int canvasX(double realX)
	{
		return (int) (realX / scale + x0);
	}

	public int canvasY(double realY)
	{
		return (int) ( -realY / scale + y0);
	}

	public double realX(int canvasX)
	{
		return ((canvasX - x0) * scale);
	}

	public double realY(int canvasY)
	{
		return ((y0 - canvasY) * scale);
	}

	@Override
	public void mouseClicked(MouseEvent arg0)
	{

		if (highLighted == null)
		{
			GObject objHere = gObjects.in(arg0.getX(), arg0.getY(), this);
			if (objHere == null || !objHere.getClass().equals(Point.class))
			{
				Point p = new Point(realX(arg0.getX()), realY(arg0.getY()));
				p.view().highLight();
				if (createSel)
				{
					p.view().select();
				}
				gObjects.add(p);
			}

		} else
		{
			gObjects.remove(highLighted);
			if (highLighted.view().getState() != EGState.SELECTED)
			{
				highLighted.view().select();
			} else
			{
				highLighted.view().highLight();
			}
			gObjects.add(highLighted);
		}
		if (highLighted != null)
			this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		else
			this.setCursor(Cursor.getDefaultCursor());
		repaint();
	}

	@Override
	public void mouseEntered(MouseEvent arg0)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseExited(MouseEvent arg0)
	{
		// TODO Auto-generated method stub

	}

	// GPoint last = null;

	public void mousePressed(MouseEvent arg0)
	{
		prevx = arg0.getX();
		prevy = arg0.getY();
		if (highLighted == null)
			this.setCursor(Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR));
	}

	@Override
	public void mouseReleased(MouseEvent arg0)
	{
		if (this.getCursor().equals(
				Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR)))
			this.setCursor(Cursor.getDefaultCursor());

	}

	private int prevx, prevy;

	@Override
	public void mouseDragged(MouseEvent arg0)
	{
		// TODO Auto-generated method stub
		x0 += arg0.getX() - prevx;
		y0 += arg0.getY() - prevy;
		prevx = arg0.getX();
		prevy = arg0.getY();
		repaint();
	}

	GObject highLighted = null;

	@Override
	public void mouseMoved(MouseEvent arg0)
	{
		// TODO Auto-generated method stub
		if (highLighted != null
				&& highLighted.view().getState() == EGState.HIGHLIGHTED)
		{
			highLighted.view().deselect();
		}

		highLighted = null;
		boolean found = false;
		Iterator<GObject> iterator = gObjects.iterator();
		while (iterator.hasNext())
		{
			GObject gobj = iterator.next();
			if (gobj.in(arg0.getX(), arg0.getY(), this) && !found)
			{
				if (gobj.view().getState() == EGState.NORMAL)
				{
					gobj.view().highLight();
				}
				highLighted = gobj;
				found = true;
			}
		}
		if (highLighted != null)
			this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		else
			this.setCursor(Cursor.getDefaultCursor());
		repaint();
	}

	@Override
	public void onDataChanged(GeomContainer source)
	{
		repaint();
	}

	public void setScale(double scale)
	{
		if (scale > 0.01 && scale < 0.2)
		{
			this.scale = scale;
			repaint();
		}
	}

	public double getScale()
	{
		return this.scale;
	}

	@Override
	public void mouseWheelMoved(MouseWheelEvent arg0)
	{
		double k = 0.005;
		this.setScale(this.getScale() - arg0.getWheelRotation() * k);

	}

	class GCSControl extends JPanel implements ChangeListener
	{

		private GCoordSystem gcs;
		private JCheckBox axes;
		private JCheckBox sel;

		public GCSControl(GCoordSystem gcs) {
			this.gcs = gcs;
			this.setLayout(new FlowLayout(FlowLayout.LEFT));
			axes = new JCheckBox("Axes");
			axes.getModel().setSelected(true);
			add(axes);
			axes.addChangeListener(this);
			sel = new JCheckBox("Selected Points");
			sel.getModel().setSelected(true);
			sel.addChangeListener(this);
			add(sel);
		}

		@Override
		public void stateChanged(ChangeEvent arg0)
		{
			if (arg0.getSource().equals(axes))
			{
				if (axes.getModel().isSelected())
					gcs.setAxes(true);
				else
					gcs.setAxes(false);
			}
			if (arg0.getSource().equals(sel))
			{
				if (sel.getModel().isSelected())
					gcs.setCreateSel(true);
				else
					gcs.setCreateSel(false);
			}

		}
	}
}