package control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;

import geom.Accur;
import geom.Algorithms;
import geom.GObject;
import geom.Point;
import geom.Segment;

import javax.swing.JButton;

import container.GeomContainer;
import container.IGeomContainerListener;

public class CommandButton extends JButton implements ActionListener
{

	private String text = "";
	// static method prototype: static void methodName(GeomContainer gObjects)
	// from Commands class
	private String methodName = "";
	GeomContainer gObjects;

	public CommandButton(String text, String methodName, GeomContainer gObjects) {
		if (text != null)
		{
			setText(text);
		}
		this.addActionListener(this);
		this.methodName = methodName;
		this.gObjects = gObjects;
	}

	@Override
	public void actionPerformed(ActionEvent arg0)
	{
		execute();
	}

	private void execute()
	{
		Class c = Commands.class;
		try
		{
			Method method = c.getMethod(methodName, GeomContainer.class);
			try
			{
				method.invoke(null, gObjects);
			} catch (IllegalAccessException | IllegalArgumentException
					| InvocationTargetException e)
			{
				e.printStackTrace();
			}
		} catch (NoSuchMethodException e)
		{
			Message.out("No method " + methodName
					+ " in class Commands!\nCheck the name.");
		} catch (SecurityException e)
		{
			Message.out("Method " + methodName
					+ " in class Commands is NOT public. Make it public.");
		}

	}
}
