package control;

import geom.Algorithms;
import geom.Circle;
import geom.GObject;
import geom.Line;
import geom.Point;
import geom.Polygon;
import geom.Segment;

import java.util.Iterator;

import container.GeomContainer;

/////////////////////////////////////////////
//Get objects from Container object by object
//////////////////////////////////////////////
/*
 Iterator<Geom> iterator = gObjects.iterator();
 while (iterator.hasNext()) {
 Geom gobj = iterator.next();
 // TODO (with gobj)...
 }
 */
/////////////////////////////////////////////
//Get objects from Container as an Array
//////////////////////////////////////////////
/*
 int N = gObject.size();
 Geom gobjs[]= new Geom[N];
 gObject.toArray(gobjs);
 */
// can use any subclass of Geom instead of Geom 
//(if sure) 
//////////////////////////////////////////////	

/**
 * \ingroup Container
 * \brief Команды - статические функции с прототипом public static void
 * methodName(GeomContainer gObjects)
 * 
 * Добавляются на объект control.CommandBox в его конструкторе или
 * непосредственным вызовом функции control.CommandBox#add(java.awt.Component)
 * 
 * Пример для функции \ref control.Commands#clear() "clear()" \code this.add(new
 * CommandButton("clear", "clear", gAllObjects)); \endcode
 * 
 * Работают c контейнером (объектом сontainer.GeomContainer)
 */
public class Commands
{
	
	/**
	 * \ingroup Container
	 * \brief Команда построения точки пересечения различных прямых
	 */
	public static void crossLines(GeomContainer gObjects)
	{

		GeomContainer sel = gObjects.getSelectedObjects();
		sel = sel.getObjectsTypeOf(Line.class);
		if (sel.size() != 2)
		{
			Message.out("You have to select exactly two LINES");
			return;
		}
		Line a[] = new Line[2];
		sel.toArray(a);
		Point p = Algorithms.vect(a[0], a[1]);
		if (p != null)
			gObjects.add(p);
		else
			Message.out("There are no cross points!");
	}

	/**
	 * \ingroup Container
	 * \brief Команда выделения всех объектов контейнера
	 */
	public static void selectAll(GeomContainer gObjects)
	{
		int N = gObjects.size();
		GObject gobjs[] = new GObject[N];
		gObjects.toArray(gobjs);
		gObjects.clear();
		for (int i = 0; i < N; i++)
		{
			gobjs[i].view().select();
			gObjects.add(gobjs[i]);
		}
	}

	/**
	 * \ingroup Container
	 * \brief Команда снятия выделения со всех объектов контейнера
	 */
	public static void deselectAll(GeomContainer gObjects)
	{
		int N = gObjects.size();
		GObject gobjs[] = new GObject[N];
		gObjects.toArray(gobjs);
		gObjects.clear();
		for (int i = 0; i < N; i++)
		{
			gobjs[i].view().deselect();
			gObjects.add(gobjs[i]);
		}
	}

	/**
	 * \ingroup Container
	 * \brief Команда удаления всех объектов из контейнера
	 */
	public static void clear(GeomContainer gObjects)
	{
		gObjects.clear();
		gObjects.remove(new Point(0, 0));
	}

	
	/**
	 * \ingroup Container
	 * \brief Команда добавления многоугольника на контейнер
	 */
	public static void makePolygon(GeomContainer gObjects)
	{
		GeomContainer sel = gObjects.getSelectedObjects();
		sel = sel.getObjectsTypeOf(Point.class);
		int N = sel.size();
		if (N < 2)
			return;

		Point points[] = new Point[N];
		sel.toArray(points);
		gObjects.add(new Polygon(points));
	}
	/**
	 * \ingroup Container
	 * \brief Команда построения прямой, проходящей через две выделенные точки
	 */
	public static void makeLine(GeomContainer gObjects)
	{
		GeomContainer sel = gObjects.getSelectedObjects();
		sel = sel.getObjectsTypeOf(Point.class);
		if (sel.size() != 2)
		{
			Message.out("You have to select exactly two POINTS");
			return;
		}
		Point a[] = new Point[2];
		sel.toArray(a);
		gObjects.add(new Line(a[0], a[1]));
	}

	/**
	 * \ingroup Container
	 * \brief Команда удаления последнего выделенного объекта из контейнера
	 */
	public static void delLastSelected(GeomContainer gObjects)
	{
		GeomContainer sel = gObjects.getSelectedObjects();
		Iterator<GObject> iterator = sel.iterator();
		if (iterator.hasNext())
		{
			gObjects.remove(iterator.next());
		}
	}

}
