package control;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.JLabel;

import container.GeomContainer;
import container.IGeomContainerListener;

public class IndicatorLabel extends JLabel implements IGeomContainerListener
{

	private String text = "";
	// static method prototype: static String methodName(GeomContainer gObjects)
	// from Indicators class
	private String methodName = "";

	public IndicatorLabel(String text, String methodName, GeomContainer source) {
		if (text != null)
		{
			this.text = text;
		}
		this.methodName = methodName;

		onDataChanged(source);
		source.addListener(this);
	}

	@Override
	public void onDataChanged(GeomContainer gObjects)
	{
		Class c = Indicators.class;
		String result = "";
		try
		{
			Method method = c.getMethod(methodName, GeomContainer.class);
			try
			{
				result = (String) method.invoke(null, gObjects);
			} catch (IllegalAccessException | IllegalArgumentException
					| InvocationTargetException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (NoSuchMethodException e)
		{
			Message.out("No method " + methodName
					+ " in class Indicators!\nCheck the name.");
		} catch (SecurityException e)
		{
			Message.out("�ethod " + methodName
					+ " in class Indicators is NOT public. �ake it public.");
		}

		this.setText(text + ": " + result);
	}

}
