package geom;

/**
 * \brief Класс для работы с вещественными числами
 */
public class Accur
{

	public static double eps = 1e-6;

	/**
	 * \brief Проверка вещественных чисел на равенство
	 */
	public static boolean eq(double a, double b)
	{
		return Math.abs(a - b) < eps;
	}

	/**
	 * \brief Проверка вещественных чисел на "меньше"
	 */
	public static boolean less(double a, double b)
	{
		return b - a > eps;
	}

	/**
	 * \brief Проверка вещественных чисел на "больше"
	 */
	public static boolean more(double a, double b)
	{
		return a - b > eps;
	}

}
