package geom;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;

import control.Message;

/**
 * \ingroup gObjects
 * \brief Абстрактный суперкласс для всех графических объектов
 */

public abstract class GObject implements Comparable
{

	GView view = new GView();

	public GView view()
	{
		return view;
	}

	/**
	 * \brief Абстракная функция рисования. Переопределяется в подклассах -
	 * конкретных графических объектах
	 */
	abstract public void draw(GCoordSystem gcs);

	/**
	 * \brief Абстракная функция определяющая принадлежность точки объекту.
	 * Переопределяется в подклассах - конкретных графических объектах
	 */
	abstract public boolean in(int canvasX, int canvasY, GCoordSystem gcs);

	public int compareTo(Object obj)
	{
		return compare(this, obj);
	}

	public static int compare(Object a, Object b)
	{
		if (a == b)
			return 0;

		if ( !a.getClass().equals(b.getClass()))
		{
			if (a.getClass().equals(Point.class))
			{

				return -1;
			} else if (b.getClass().equals(Point.class))
			{

				return 1;
			} else
			{
				return a.getClass().hashCode() > b.getClass().hashCode() ? 1
						: -1;
			}
		}

		GObject ga = (GObject) a;
		GObject gb = (GObject) b;
		if (ga.view().getSelId() > gb.view().getSelId())
			return -1;
		if (ga.view().getSelId() < gb.view().getSelId())
			return 1;

		int res = 0;

		Field[] fieldsA = a.getClass().getFields();
		Field[] fieldsB = b.getClass().getFields();
		try
		{
			for (int i = 0; i < fieldsA.length && res == 0; i++)
			{
				Field fa = fieldsA[i];

				if (fa.getType().equals(Point[].class))
				{
					Point pa[] = (Point[]) fa.get(a);
					Point pb[] = (Point[]) fa.get(b);
					if (pa.length < pb.length)
						return -1;
					if (pa.length > pb.length)
						return 1;
					for (int j = 0; j < pa.length; j++)
					{
						res = compare(pa[j], pb[j]);
						if (res != 0)
							return res;
					}
					return 0;
				}

				if (fa.getType().equals(Point.class))
				{

					res = compare((Point) (fa.get(a)), (Point) (fa.get(b)));

				}
				if (fa.getType().getName().equals("int"))
				{
					if ((int) (fa.get(a)) > (int) (fa.get(b)))
						res = 1;
					if ((int) (fa.get(a)) < (int) (fa.get(b)))
						res = -1;
				}
				if (fa.getType().getName().equals("long"))
				{
					if ((long) (fa.get(a)) > (long) (fa.get(b)))
						res = 1;
					if ((long) (fa.get(a)) < (long) (fa.get(b)))
						res = -1;
				}
				if (fa.getType().getName().equals("double"))
				{
					if (geom.Accur.less((double) (fa.get(a)),
							(double) (fa.get(b))))
						res = -1;
					if (geom.Accur.more((double) (fa.get(a)),
							(double) (fa.get(b))))
						res = 1;

				}
			}
		} catch (IllegalArgumentException | IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return res;
	}
}
