package geom;

import java.awt.Color;

/**
 * \ingroup gObjects
 * \brief Точка. Определяется двумя числами - координами в декартовой системе
 * координат.
 */
public class Point extends GObject
{

	public double x;
	public double y;
	static int size = 10;

	public Point(double x, double y) {
		this.x = x;
		this.y = y;
	}

	public void draw(GCoordSystem gcs)
	{
		Color prevColor = gcs.getCanvas().getColor();
		view().chooseColor(Color.BLACK, Color.YELLOW, Color.GREEN, gcs);
		gcs.getCanvas().fillOval(gcs.canvasX(x) - size / 2,
				gcs.canvasY(y) - size / 2, size, size);
		gcs.getCanvas().setColor(prevColor);
	}

	public boolean in(int canvasX, int canvasY, GCoordSystem gcs)
	{

		if (Algorithms.distance(this,
				new Point(gcs.realX(canvasX), gcs.realY(canvasY)))
				/ gcs.getScale() < gcs.gEps)
			return true;
		return false;
	}
}
