package geom;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Color;
import java.awt.Composite;
import java.util.Arrays;

/**
 * \ingroup gObjects
 * \brief Многоугольник. Определяется массивом точек
 */
public class Polygon extends GObject
{

	public Point[] p;

	public Polygon(Point[] p) {
		this.p = Arrays.copyOf(p, p.length);
	}

	@Override
	public void draw(GCoordSystem gcs)
	{
		Composite prevac = gcs.getCanvas().getComposite();
		Color prevcolor = gcs.getCanvas().getColor();
		view().chooseColor(new Color(150, 150, 150), Color.YELLOW,
				new Color(150, 200, 150), gcs);
		AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
				(float) 0.5);

		gcs.getCanvas().setComposite(ac);

		int[] drawpx = new int[p.length];
		int[] drawpy = new int[p.length];
		for (int i = 0; i < p.length; i++)
		{
			drawpx[i] = gcs.canvasX(p[i].x);
			drawpy[i] = gcs.canvasY(p[i].y);
		}
		java.awt.Polygon drawpoly = new java.awt.Polygon(drawpx, drawpy,
				p.length);
		gcs.getCanvas().fillPolygon(drawpoly);
		gcs.getCanvas().setColor(prevcolor);
		gcs.getCanvas().setComposite(prevac);
	}

	@Override
	public boolean in(int canvasX, int canvasY, GCoordSystem gcs)
	{
		return false;
		// TODO Auto-generated method stub
		// Point p = new Point(gcs.realX(canvasX), gcs.realY(canvasY));
		// return Math.abs(this.p1.distance(p) + p.distance(p2)- p1.
		// distance(p2)) / gcs.getScale() < gcs.g�ps;
	}

}
