package geom;

import java.util.Arrays;

/**
 * \ingroup Algorithms
 * \brief Основной класс - функции геометрических алгоритмов Используются \ref
 * control.Commands "команадами"
 */
public class Algorithms
{

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет квадрат расстояния между двумя точками, заданных
	 * координатами
	 */
	public static double distance2(double x1, double y1, double x2, double y2)
	{
		return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет квадрат расстояния между двумя точками
	 */
	public static double distance2(Point p1, Point p2)
	{
		return distance2(p1.x, p1.y, p2.x, p2.y);
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет косое произведение векторов (a, b) и (c, d)
	 */
	public static double det(double a, double b, double c, double d)
	{
		return a * d - b * c;
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет косое произведение векторов, заданных двумя точками
	 */
	public static double vect(Point a1, Point a2, Point b1, Point b2)
	{
		return (a2.x - a1.x) * (b2.y - b1.y) - (b2.x - b1.x) * (a2.y - a1.y);
	}

	
	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет точку пересечения прямых. Возвращает null, если прямые
	 * параллельны
	 */
	public static Point vect(Line m, Line n)
	{

		double k = det(m.a, m.b, n.a, n.b);
		if (Accur.eq(k, 0))
			return null;
		return new Point( -det(m.c, m.b, n.c, n.b) / k,
				-det(m.a, m.c, n.a, n.c) / k);
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет расстояние между двумя точками, заданных координатами
	 */
	public static double distance(double x1, double y1, double x2, double y2)
	{
		return Math.sqrt(distance2(x1, y1, x2, y2));
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет расстояние между двумя точками
	 */
	public static double distance(Point p1, Point p2)
	{
		return distance(p1.x, p1.y, p2.x, p2.y);
	}
	
	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет середину отрезка
	 */
	public Point midPoint(Segment s)
	{
		return new Point((s.p1.x + s.p2.x) / 2, ((s.p1.y + s.p2.y) / 2));
	}

	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет длину отрезка
	 */
	public double len(Segment s)
	{
		return distance(s.p1, s.p2);
	}
	/**
	 * \ingroup Algorithms
	 * \brief Вычисляет расстояние между точкой и окружностью
	 */
	public static double distance(Point p, Circle circle)
	{
		double d = distance(circle.c, p);
		return d > circle.r ? d - circle.r : circle.r - d;
	}

}