package geom;

import java.awt.Color;

import geom.Point;

/**
 * \ingroup gObjects
 * \brief Окружность. Определяется точкой центра и радиусом
 */
public class Circle extends GObject
{

	public double r;
	public Point c;

	public Circle(double x0, double y0, double r) {
		this(new Point(x0, y0), r);
	}

	public Circle(Point c, double r) {
		this.c = c;
		this.r = r;
	}

	@Override
	public void draw(GCoordSystem gcs)
	{
		Color prevColor = gcs.getCanvas().getColor();
		view().chooseColor(Color.BLACK, Color.YELLOW, Color.GREEN, gcs);
		double scale = gcs.getScale();
		gcs.getCanvas().drawOval(gcs.canvasX(c.x) - (int) (r / scale),
				gcs.canvasY(c.y) - (int) (r / scale), 2 * (int) (r / scale),
				2 * (int) (r / scale));

		gcs.getCanvas().fillOval(gcs.canvasX(c.x) - 1, gcs.canvasY(c.y) - 1, 3,
				3);

		gcs.getCanvas().setColor(prevColor);
	}

	@Override
	public boolean in(int canvasX, int canvasY, GCoordSystem gcs)
	{
		if (Algorithms.distance(
				new Point(gcs.realX(canvasX), gcs.realY(canvasY)), this.c)
				/ gcs.getScale() < gcs.gEps
				|| Algorithms
						.distance(
								new Point(gcs.realX(canvasX), gcs
										.realY(canvasY)), this)
						/ gcs.getScale() < gcs.gEps)
			return true;
		return false;
	}

}
