package geom;

import java.awt.Color;

/**
 * \ingroup gObjects
 * \brief Прямая. Определяется двумя точками
 */
public class Line extends GObject
{

	public double a, b, c;

	public Line(double a, double b, double c) {
		this.a = a;
		this.b = b;
		this.c = c;
	}

	public Line(Point p1, Point p2) {
		a = p1.y - p2.y;
		b = p2.x - p1.x;
		c = -(a * p1.x + b * p1.y);
		double k = 1 / Math.sqrt(a * a + b * b);
		a /= k;
		b /= k;
		c /= k;
	}

	public double y(double x)
	{
		return (( -c - a * x) / b);
	}

	public double distance(Point p)
	{
		return distance(p.x, p.y);
	}

	public double distance(double x, double y)
	{
		return Math.abs(a * x + b * y + c) / Math.sqrt(a * a + b * b);
	}

	@Override
	public void draw(GCoordSystem gcs)
	{
		double x1, y1, x2, y2;
		if ( !Accur.eq(b, 0))
		{
			x1 = gcs.realX(0);
			y1 = y(x1);
			x2 = gcs.realX(gcs.getWidth());
			y2 = y(x2);
		} else
		{
			x1 = -c / a;
			y1 = gcs.realY(0);
			x2 = x1;
			y2 = gcs.realY(gcs.getHeight());
		}
		Color prevcolor = gcs.getCanvas().getColor();
		view().chooseColor(Color.BLACK, Color.YELLOW, Color.GREEN, gcs);
		gcs.getCanvas().drawLine(gcs.canvasX(x1), gcs.canvasY(y1),
				gcs.canvasX(x2), gcs.canvasY(y2));
		gcs.getCanvas().setColor(prevcolor);
	}

	@Override
	public boolean in(int canvasX, int canvasY, GCoordSystem gcs)
	{
		if (distance(gcs.realX(canvasX), gcs.realY(canvasY)) / gcs.getScale() < gcs.gEps)
			return true;
		else
			return false;
	}

}