package geom;

import java.awt.Color;

/**
 * \ingroup gObjects
 * \brief Отрезок. Определяется двумя точками
 */
public class Segment extends GObject
{
	public Point p1, p2;

	public Segment(Point p1, Point p2) {
		this.p1 = p1;
		this.p2 = p2;
	}

	public Segment(int x1, int y1, int x2, int y2) {
		this(new Point(x1, y1), new Point(x2, y2));
	}

	@Override
	public void draw(GCoordSystem gcs)
	{

		Color prevcolor = gcs.getCanvas().getColor();
		view().chooseColor(Color.BLACK, Color.YELLOW, Color.GREEN, gcs);
		gcs.getCanvas().drawLine(gcs.canvasX(p1.x), gcs.canvasY(p1.y),
				gcs.canvasX(p2.x), gcs.canvasY(p2.y));
		gcs.getCanvas().setColor(prevcolor);

	}

	@Override
	public boolean in(int canvasX, int canvasY, GCoordSystem gcs)
	{
		// TODO Auto-generated method stub
		Point p = new Point(gcs.realX(canvasX), gcs.realY(canvasY));
		return Math
				.abs(Algorithms.distance(this.p1, p)
						+ Algorithms.distance(this.p2, p)
						- Algorithms.distance(p1, p2))
				/ gcs.getScale() < gcs.gEps;
	}

}
