#include <vector>
#include <algorithm>
#include "UniqueCounter.h"

using namespace std;

const uint min_number = 0;
const uint max_number = 0xfffffff;

UniqueCounter::UniqueCounter(uint N) {
    mn = max_number;
    mx = min_number;
    cnt = 0;
}

void UniqueCounter::process(uint x) {
    mn = min(mn, x);
    mx = max(mx, x);
    cnt += 1;
}

double UniqueCounter::predict() {
    return min(mx - mn + 1, cnt);
}


